/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASFormatter;
import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASMessageCatalog;
import com.ibm.ras.RASMessageEvent;
import com.ibm.ras.RASUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.MissingResourceException;

public class RASMessageFormatter
extends RASFormatter {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private static String[] attribs = new String[]{"className", "methodName", "organization", "product", "component", "server", "client"};

    public RASMessageFormatter() {
        this.addEventClass("com.ibm.ras.RASMessageEvent");
    }

    public String format(RASIEvent rASIEvent) {
        String string = this.getSeparator();
        StringBuffer stringBuffer = new StringBuffer(256);
        RASMessageEvent rASMessageEvent = (RASMessageEvent)rASIEvent;
        long l = rASMessageEvent.getTimeStamp();
        stringBuffer.append(String.valueOf(this.getDate(l)) + string);
        stringBuffer.append(String.valueOf(this.getTime(l)) + string);
        int n = 0;
        while (n < attribs.length) {
            String string2 = (String)rASMessageEvent.getAttribute(attribs[n]);
            if (string2 != null) {
                stringBuffer.append(String.valueOf(string2) + string);
            }
            ++n;
        }
        String string3 = rASMessageEvent.getText();
        Object[] objectArray = rASMessageEvent.getParameters();
        String string4 = rASMessageEvent.getMessageFile();
        Exception exception = (Exception)rASMessageEvent.getAttribute("exception");
        if (exception != null) {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            stringBuffer.append(stringWriter.toString());
        } else if (string4 == null) {
            stringBuffer.append(string3);
            if (objectArray != null) {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    stringBuffer.append(", p" + (n2 + 1) + "=" + (String)objectArray[n2]);
                    ++n2;
                }
            }
        } else {
            RASMessageCatalog rASMessageCatalog = null;
            String string5 = null;
            try {
                rASMessageCatalog = new RASMessageCatalog(string4);
                string5 = rASMessageCatalog.getMessage(string3, objectArray);
            }
            catch (MissingResourceException missingResourceException) {
                string5 = RASUtil.rasMsgs.getMessage("ERR_MISSING_KEY", string3);
            }
            stringBuffer.append(string5);
        }
        return stringBuffer.toString();
    }
}

